<?php
require 'vendor/autoload.php';  // Load Google API client library (after composer installation)

include "includes/config.php";
$setting_qry    = "SELECT * FROM tbl_settings where id = '1'";
$setting_result = mysqli_query($connect, $setting_qry);
$settings_row   = mysqli_fetch_assoc($setting_result);
$app_fcm_key    = $settings_row['app_fcm_key'];
define("APP_FCM_KEY", $app_fcm_key);
$projectID = 'TESTING';
$data = json_encode(htmlspecialchars($app_fcm_key), true);
//var_dump($data);die;
//echo $data['type']; die;
if (file_exists(UPLOAD_FULL_JSON_PATH)) {
    $json = json_decode(file_get_contents(UPLOAD_FULL_JSON_PATH), true);
    if (isset($json['project_id'])) {
        $projectID = $json['project_id'];
    }
}

function Insert($table, $data)
{

    include 'includes/config.php';
    $fields = array_keys($data);
    $values = array_map(array($connect, 'real_escape_string'), array_values($data));

    $sql = "INSERT INTO $table (" . implode(",", $fields) . ") VALUES ('" . implode("','", $values) . "')";
    mysqli_query($connect, $sql);
}

function Delete($table_name, $where_clause = '')
{

    include 'includes/config.php';
    $whereSQL = '';
    if (!empty($where_clause)) {
        if (substr(strtoupper(trim($where_clause)), 0, 5) != 'WHERE') {
            $whereSQL = " WHERE " . $where_clause;
        } else {
            $whereSQL = " " . trim($where_clause);
        }
    }
    $sql = "DELETE FROM " . $table_name . $whereSQL;
    return mysqli_query($connect, $sql);
}

// Update Data, Where clause is left optional
function Update($table_name, $form_data, $where_clause = '')
{

    include 'includes/config.php';
    // check for optional where clause
    $whereSQL = '';
    if (!empty($where_clause)) {
        // check to see if the 'where' keyword exists
        if (substr(strtoupper(trim($where_clause)), 0, 5) != 'WHERE') {
            // not found, add key word
            $whereSQL = " WHERE " . $where_clause;
        } else {
            $whereSQL = " " . trim($where_clause);
        }
    }
    // start the actual SQL statement
    $sql = "UPDATE " . $table_name . " SET ";

    // loop and build the column /
    $sets = array();
    foreach ($form_data as $column => $value) {
        $sets[] = "`" . $column . "` = '" . $value . "'";
    }
    $sql .= implode(', ', $sets);

    // append the where statement
    $sql .= $whereSQL;

    // run and return the query result
    return mysqli_query($connect, $sql);
}

function getAccessToken()
{
    $client = new \Google_Client();
    $client->setAuthConfig(UPLOAD_FULL_JSON_PATH);  // Path to your service account JSON file
    $client->addScope('https://www.googleapis.com/auth/firebase.messaging');

    // Get OAuth 2.0 token
    $token = $client->fetchAccessTokenWithAssertion();
    return $token['access_token'];
}

//FCM function
function SEND_FCM_NOTIFICATION($deviceToken, $data)
{
    global $projectID;
    // FCM endpoint
    $url = 'https://fcm.googleapis.com/v1/projects/' . $projectID . '/messages:send';  // Replace YOUR_PROJECT_ID with your Firebase project ID

    // Get the access token
    $accessToken = getAccessToken();

    $notification = [
        "message" => [
            "token" => $deviceToken,  // Array of tokens
            "data" => $data
        ]
    ];

    $data_string = json_encode($notification);

    // Set headers
    $headers = [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ];

    // Initialize curl
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);

    // Send the request
    $response = curl_exec($ch);
    // Close curl
    if ($response === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }

    curl_close($ch);
    return $response;
}
