<?php

require_once("Rest.inc.php");

class API extends REST
{

	public $data = "";
	const demo_version = false;

	private $db 	= NULL;
	private $mysqli = NULL;
	public function __construct()
	{
		// Init parent contructor
		parent::__construct();
		// Initiate Database connection
		$this->dbConnect();
		date_default_timezone_set('Asia/Kolkata');
	}

	/*
		 *  Connect to Database
		*/
	private function dbConnect()
	{
		include "../includes/config.php";
		$this->mysqli = new mysqli($host, $user, $pass, $database);
		$this->mysqli->query('SET CHARACTER SET utf8');
	}

	/*
		 * Dynmically call the method based on the query string
		 */
	public function processApi()
	{
		$func = strtolower(trim(str_replace("/", "", $_REQUEST['x'])));
		if ((int)method_exists($this, $func) > 0)
			$this->$func();
		else {
			$response = array('status' => FAIL, 'message' => MSG_NO_METHOD_FOUND);
			$this->response($this->json($response), 404);	// If the method not exist with in this class "Page not found".
		}
	}

	/* Api Checker */
	private function checkConnection()
	{
		if (mysqli_ping($this->mysqli)) {
			$response = array('status' => SUCCESS, 'database' => 'connected');
			$this->response($this->json($response), 200);
		} else {
			$response = array('status' => FAIL, 'database' => 'not connected');
			$this->response($this->json($response), 404);
		}
	}

	private function getAPIValid()
	{
		if (isset($_GET['api_key'])) {
			include "../includes/config.php";
			$access_key_received = $_GET['api_key'];
			$setting_qry    = "SELECT * FROM tbl_settings where api_key = '$access_key_received'";
			$setting_result = mysqli_query($connect, $setting_qry);
			$settings_row   = mysqli_fetch_assoc($setting_result);
			if (isset($settings_row)) {
				$api_key    = $settings_row['api_key'];
				return $api_key;
			} else {
				$response = array('status' => FAIL, 'message' => MSG_API_KEY_INCORRECT);
				$this->response($this->json($response), 200);
			}
		} else {
			$response = array('status' => FAIL, 'message' => MSG_API_KEY_REQUIRED);
			$this->response($this->json($response), 200);
		}
	}

	private function login()
	{

		$api_key = $this->getAPIValid();

		$date = $this->getISTDateTime();

		if (isset($api_key)) {
			include "../includes/config.php";
			if ($this->get_request_method() != "GET") $this->response('', 406);
			if (isset($this->_request['username']) && isset($this->_request['password'])) {
				$username = $this->_request['username'];
				$password = $this->_request['password'];
				$device_type = isset($this->_request['device_type']) ? $this->_request['device_type'] : 'Android';

				$password = hash('sha256', $username . $password);

				$query = "SELECT 
								id, 
								username, 
								email,
								device_type, 
								active, 
								createdAt, 
								updatedAt 
								FROM 
									tbl_user 
								WHERE 
									(username = '$username' AND password='$password') OR (email = '$username' AND e_password='$password') ";

				$userData = $this->get_list_result($query);
				$count = count($userData);

				if ($count > 0) {
					$sql_query = "UPDATE tbl_user SET device_type=?, updatedAt=?  WHERE id=?";
					$userData[0]['device_type'] = $device_type;
					$userData[0]['updatedAt'] = $date;
					$stmt = $connect->stmt_init();
					if ($stmt->prepare($sql_query)) {
						$stmt->bind_param('ssi', $device_type, $date, $userData[0]['id']);
						$stmt->execute();
						$update_result = $stmt->store_result();
						$stmt->close();
					}
					$response = array('status' => SUCCESS, 'message' => MSG_LOGIN_SUCCESS, 'data' => $userData[0]);
					$this->response($this->json($response), 200);
				} else {
					$response = array('status' => FAIL, 'message' => MSG_INVALID_USER_PASS);
					$this->response($this->json($response), 200);
				}
			} else {
				$response = array('status' => FAIL, 'message' => MSG_REQUIRED_PARAMS);
				$this->response($this->json($response), 200);
			}
		} else {
			$response = array('status' => FAIL, 'message' => MSG_API_KEY_INCORRECT);
			$this->response($this->json($response), 200);
		}
	}

	private function register()
	{

		$api_key = $this->getAPIValid();

		$date = $this->getISTDateTime();

		if (isset($api_key)) {
			include "../includes/config.php";
			if ($this->get_request_method() != "GET") $this->response('', 406);
			if (isset($this->_request['username']) && isset($this->_request['password']) && isset($this->_request['email'])) {
				$username = $this->_request['username'];
				$password = $this->_request['password'];
				$email = $this->_request['email'];
				$user_role = 102;
				$active = '1';

				$query = "SELECT 
									id, 
									username, 
									email, 
									device_type, 
									active, 
									createdAt, 
									updatedAt 
								FROM 
									tbl_user 
								WHERE 
									email='$email' OR username='$username' ";

				$user = $this->get_list_result($query);
				$count = count($user);
				if ($count > 0) {
					$response = array('status' => FAIL, 'message' => MSG_RECORD_ALREADY_EXIST);
					$this->response($this->json($response), 200);
				} else {
					$password = hash('sha256', $username . $password);
					$e_password = hash('sha256', $email . $password);

					$sql = "INSERT INTO tbl_user (username, password, e_password, email, user_role, active, createdAt, updatedAt) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

					$insert = $connect->prepare($sql);
					$insert->bind_param('ssssssss', $username, $password, $e_password, $email, $user_role, $active, $date, $date);
					$insert->execute();

					$query = "SELECT id, username, email, device_type, active, createdAt, updatedAt FROM tbl_user WHERE username='$username' AND email='$email'";
					$userData = $this->get_object_result($query);
					$response = array('status' => SUCCESS, 'message' => MSG_REGISTER_SUCCESS, 'data' => $userData);
					$this->response($this->json($response), 200);
				}
			} else {
				$response = array('status' => FAIL, 'message' => MSG_REQUIRED_PARAMS);
				$this->response($this->json($response), 200);
			}
		} else {
			$response = array('status' => FAIL, 'message' => MSG_API_KEY_INCORRECT);
			$this->response($this->json($response), 200);
		}
	}

	private function changePassword()
	{

		$api_key = $this->getAPIValid();

		$date = $this->getISTDateTime();

		if (isset($api_key)) {
			include "../includes/config.php";
			if ($this->get_request_method() != "GET") $this->response('', 406);
			if (isset($this->_request['username']) && isset($this->_request['email']) && isset($this->_request['old_password']) && isset($this->_request['new_password'])) {
				$username = $this->_request['username'];
				$email = $this->_request['email'];
				$old_password = $this->_request['old_password'];
				$new_password = $this->_request['new_password'];

				if ($username === "admin" || $email === "bytesbee@gmail.com") {
					$response = array('status' => FAIL, 'message' => 'Sorry! You are not authorised user to change password');
					$this->response($this->json($response), 200);
				} else {
					$password = hash('sha256', $username . $old_password);
					$e_password = hash('sha256', $email . $old_password);

					$query = "SELECT * FROM tbl_user WHERE 
									(username = '$username' AND password='$password') OR 
									(email = '$email' AND e_password='$e_password') ";
					$userData = $this->get_list_result($query);
					$count = count($userData);

					if ($count > 0) {
						$new_u_password = hash('sha256', $username . $new_password);
						$new_e_password = hash('sha256', $email . $new_password);

						$sql_query = "UPDATE tbl_user SET updatedAt=? ,password=?, e_password=? WHERE id=?";
						$stmt = $connect->stmt_init();
						if ($stmt->prepare($sql_query)) {
							$stmt->bind_param('sssi', $date, $new_u_password, $new_e_password, $userData[0]['id']);
							$stmt->execute();
							$update_result = $stmt->store_result();
							$stmt->close();
						}
						$userData[0]['updatedAt'] = $date;
						$userData[0]['password'] = $new_u_password;
						$userData[0]['e_password'] = $new_e_password;
						$response = array('status' => SUCCESS, 'message' => MSG_CHANGE_PASSWORD, 'data' => $userData[0]);
						$this->response($this->json($response), 200);
					} else {
						$response = array('status' => FAIL, 'message' => MSG_INVALID_PASSWORD);
						$this->response($this->json($response), 200);
					}
				}
			} else {
				$response = array('status' => FAIL, 'message' => MSG_REQUIRED_PARAMS);
				$this->response($this->json($response), 200);
			}
		} else {
			$response = array('status' => FAIL, 'message' => MSG_API_KEY_INCORRECT);
			$this->response($this->json($response), 200);
		}
	}

	private function getSingleChannel()
	{
		$api_key = $this->getAPIValid();

		if (isset($api_key)) {
			include "../includes/config.php";
			include "../templates/functions.php";
			if ($this->get_request_method() != "GET") $this->response('', 406);

			$allQueryFields = $this->getQueryFields();

			$query = "SELECT distinct $allQueryFields";

			$post = $this->get_list_result($query);
			$data = $post[0];
			$function = new functions;
			$channel_url = $data['channel_url'];
			$channel_url_two = $data['channel_url_two'];
			//$channel_url= "https://www.youtube.com/watch?v=lVm3G2t3wDQ";
			$id_1 = $function->ParseYoutubeLink($channel_url);
			$id_2 = $function->ParseYoutubeLink($channel_url_two);
			$data['channel_type_1'] = $id_1['type'];
			$data['channel_type_2'] = $id_2['type'];
			$data['isYT_1'] = $id_1['isYT'];
			$data['isYT_2'] = $id_2['isYT'];
			//print_r($id_1); die;
			$thumb_one = $function->getInfo($channel_url);
			$thumb_two = $function->getInfo($channel_url_two);
			//echo($function->isYouTubeURL($channel_url)); die;
			if ($id_1['isYT'] === 'true') {
				$data['youtube_image'] = $thumb_one->thumbnail_url;
				$data['channel_video_id'] = $function->ParseYoutubeLink($channel_url)['value'];
			} else {
				$data['channel_video_id'] = '';
				$data['youtube_image'] = '';
			}
			if ($id_2['isYT'] === 'true') {
				$data['youtube_image_two'] = $thumb_two->thumbnail_url;
				$data['channel_video_id_two'] = $function->ParseYoutubeLink($channel_url_two)['value'];
			} else {
				$data['channel_video_id_two'] = '';
				$data['youtube_image_two'] = '';
			}
			$post = array($data);

			$response = array(
				'status' => SUCCESS,
				'posts' => $post
			);

			$this->response($this->json($response), 200);
		} else {
			$response = array('status' => FAIL, 'message' => MSG_API_KEY_INCORRECT);
			$this->response($this->json($response), 200);
		}
	}

	private function getQueryFields()
	{
		$data = " 
					n.id AS 'channel_id', 
					n.channel_name, 
					n.channel_type, 
					n.channel_video_id,
					n.channel_video_id_two,
					CONCAT('channel/', '', n.channel_image) as channel_image,
					CONCAT('https://img.youtube.com/vi/', '', n.channel_video_id,'/mqdefault.jpg') as youtube_image,
					CONCAT('https://img.youtube.com/vi/', '', n.channel_video_id_two,'/mqdefault.jpg') as youtube_image_two,
					n.link1_label, 
					n.link2_label, 
					n.channel_url, 
					n.channel_url_two, 
					n.channel_user_agent,
					n.channel_description,
					(SELECT COUNT(link1_name) FROM tbl_link_count l WHERE n.id=l.channel_id AND link1_name!=0) link1_count,
					(SELECT COUNT(link2_name) FROM tbl_link_count l WHERE n.id=l.channel_id AND link2_name!=0) link2_count,
                    (SELECT COUNT(link1_name) FROM tbl_link_count l WHERE n.id=l.channel_id) total_count, 
					n.createdAt, 
					n.updatedAt 
				FROM
					tbl_channel n where n.active=1";
		return $data;
	}

	private function insertLinkCount()
	{
		$api_key = $this->getAPIValid();

		$datetime = $this->getISTDateTime();
		$date = $this->getISTDate();
		$time = $this->getISTTime();

		if (isset($api_key)) {
			include "../includes/config.php";
			if ($this->get_request_method() != "GET") $this->response('', 406);
			$link1_name = isset($this->_request['link1_name']) ? $this->_request['link1_name'] : 0;
			$link2_name = isset($this->_request['link2_name']) ? $this->_request['link2_name'] : 0;
			$channel_id = isset($this->_request['channel_id']) ? $this->_request['channel_id'] : 1;
			$channel_type = isset($this->_request['channel_type']) ? $this->_request['channel_type'] : STREAMING;

			if ($channel_type === STREAMING) {
				$channel_type = 1;
			} else if ($channel_type === YOUTUBE) {
				$channel_type = 2;
			} else {
				$channel_type = 3;
			}

			$query = "SELECT * from tbl_channel  WHERE id = '$channel_id'";
			$user = $this->get_list_result($query);
			$count = count($user);
			if ($count <= 0) {
				$response = array('status' => FAIL, 'message' => MSG_RECORD_NOT_FOUND);
				$this->response($this->json($response), 200);
			} else {

				$sql = "INSERT INTO tbl_link_count (channel_id, link1_name, link2_name, channel_type, createdDate, createdTime, createdAt) VALUES (?, ?, ?, ?, ?, ?, ?)";

				$insert = $connect->prepare($sql);
				$insert->bind_param('sssssss', $channel_id, $link1_name, $link2_name, $channel_type, $date, $time, $datetime);
				$insert->execute();

				$query = "SELECT *, (link1_count + link2_count) total_count FROM (
								(SELECT COUNT(link1_name) link1_count FROM tbl_link_count l WHERE l.channel_id = $channel_id AND link1_name!=0) link1_count,
								(SELECT COUNT(link2_name) link2_count FROM tbl_link_count l WHERE l.channel_id = $channel_id AND link2_name!=0) link2_count)";
				$result = $this->get_object_result($query);

				$response = array('status' => SUCCESS, 'message' => MSG_RECORD_FOUND, 'data' => $result);
				$this->response($this->json($response), 200);
			}
		} else {
			$response = array('status' => FAIL, 'message' => MSG_API_KEY_INCORRECT);
			$this->response($this->json($response), 200);
		}
	}

	private function getLatestLinkView()
	{
		include "../includes/config.php";

		if ($this->get_request_method() != "GET") $this->response('', 406);

		$query = "SELECT SUM(link1_name) link1_name, SUM(link2_name) link2_name, DATE_FORMAT(createdDate, '%b %d') as createdDate 
						FROM tbl_link_count GROUP BY createdDate ORDER BY id DESC LIMIT 7";

		$result = array_reverse($this->get_list_result($query));

		$response = array('status' => SUCCESS, 'data' => $result);

		$this->response($this->json($response), 200);
	}

	private function getAppSettings()
	{
		$api_key = $this->getAPIValid();

		if (isset($api_key)) {
			include "../includes/config.php";
			if ($this->get_request_method() != "GET") $this->response('', 406);

			$query = "SELECT *, CONCAT(app_version, ' ')  as app_version FROM tbl_settings where id = '1'";
			$data = $this->get_object_result($query);
			$response = array('status' => SUCCESS, 'message' => MSG_RECORD_FOUND, 'data' => $data);
			$this->response($this->json($response), 200);
		} else {
			$response = array('status' => FAIL, 'message' => MSG_API_KEY_INCORRECT);
			$this->response($this->json($response), 200);
		}
	}

	/**
	 * =========================================================================================================
	 *	COMMON METHODS  
	 * =========================================================================================================
	 */
	private function getCurrentDate()
	{
		return date('Y-m-d H:i:s', time());
	}

	private function getISTDateTime()
	{
		return $this->getCurrentDate();
	}

	private function getISTDate()
	{
		return date('Y-m-d', time());
	}

	private function getISTTime()
	{
		return date('H:i:s', time());
	}

	//don't edit all the code below
	private function get_list($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = array();
			while ($row = $r->fetch_assoc()) {
				$result[] = $row;
			}
			$this->response($this->json($result), 200); // send user details
		}
		$this->response('', 204);	// If no records "No Content" status
	}

	private function get_list_result($query)
	{
		$result = array();
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			while ($row = $r->fetch_assoc()) {
				$result[] = $row;
			}
		}
		return $result;
	}

	private function get_object_result($query)
	{
		$result = array();
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			while ($row = $r->fetch_assoc()) {
				$result = $row;
			}
		}
		return $result;
	}

	private function get_one($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = $r->fetch_assoc();
			$this->response($this->json($result), 200); // send user details
		}
		$this->response('', 204);	// If no records "No Content" status
	}

	private function get_count($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = $r->fetch_row();
			$this->response($result[0], 200);
		}
		$this->response('', 204);	// If no records "No Content" status
	}

	private function get_count_result($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = $r->fetch_row();
			return $result[0];
		}
		return 0;
	}

	private function post_one($obj, $column_names, $table_name)
	{
		$keys 		= array_keys($obj);
		$columns 	= '';
		$values 	= '';
		foreach ($column_names as $desired_key) {
			if (!in_array($desired_key, $keys)) {
				$$desired_key = '';
			} else {
				$$desired_key = $obj[$desired_key];
			}
			$columns 	= $columns . $desired_key . ',';
			$values 	= $values . "'" . $this->real_escape($$desired_key) . "',";
		}
		$query = "INSERT INTO " . $table_name . "(" . trim($columns, ',') . ") VALUES(" . trim($values, ',') . ")";

		if (!empty($obj)) {

			if ($this->mysqli->query($query)) {
				$status = "success";
				$msg 		= $table_name . " created successfully";
			} else {
				$status = "failed";
				$msg 		= $this->mysqli->error . __LINE__;
			}
			$resp = array('status' => $status, "msg" => $msg, "data" => $obj);
			$this->response($this->json($resp), 200);
		} else {
			$this->response('', 204);	//"No Content" status
		}
	}

	private function post_update($id, $obj, $column_names, $table_name)
	{
		$keys = array_keys($obj[$table_name]);
		$columns = '';
		$values = '';
		foreach ($column_names as $desired_key) {
			if (!in_array($desired_key, $keys)) {
				$$desired_key = '';
			} else {
				$$desired_key = $obj[$table_name][$desired_key];
			}
			$columns = $columns . $desired_key . "='" . $this->real_escape($$desired_key) . "',";
		}

		$query = "UPDATE " . $table_name . " SET " . trim($columns, ',') . " WHERE id=$id";
		if (!empty($obj)) {
			if ($this->mysqli->query($query)) {
				$status = "success";
				$msg 	= $table_name . " update successfully";
			} else {
				$status = "failed";
				$msg 	= $this->mysqli->error . __LINE__;
			}
			$resp = array('status' => $status, "msg" => $msg, "data" => $obj);
			$this->response($this->json($resp), 200);
		} else {
			$this->response('', 204);	// "No Content" status
		}
	}

	private function delete_one($id, $table_name)
	{
		if ($id > 0) {
			$query = "DELETE FROM " . $table_name . " WHERE id = $id";
			if ($this->mysqli->query($query)) {
				$status = "success";
				$msg 		= "One record " . $table_name . " successfully deleted";
			} else {
				$status = "failed";
				$msg 		= $this->mysqli->error . __LINE__;
			}
			$resp = array('status' => $status, "msg" => $msg);
			$this->response($this->json($resp), 200);
		} else {
			$this->response('', 204);	// If no records "No Content" status
		}
	}

	private function responseInvalidParam()
	{
		$resp = array("status" => 'Failed', "msg" => 'Invalid Parameter');
		$this->response($this->json($resp), 200);
	}

	/* ==================================== End of API utilities ==========================================
		 * ====================================================================================================
		 */

	/* Encode array into JSON */
	private function json($data)
	{
		if (is_array($data)) {
			return json_encode($data, JSON_NUMERIC_CHECK);
		}
	}

	/* String mysqli_real_escape_string */
	private function real_escape($s)
	{
		return mysqli_real_escape_string($this->mysqli, $s);
	}
}

// Initiate Library
$api = new API;
$api->processApi();
